/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.util.List;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.ExcludePackageProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallHierarchyExplorer {
    private static final Logger log = Logger.getLogger(CallHierarchyExplorer.class);
    private static final int TRACE_MAX = 30;
    private static final CallHierarchyExplorer singleton = new CallHierarchyExplorer();
    private final ExcludePackageProperties excludePackageProperties = ExcludePackageProperties.getInstance();

    public static CallHierarchyExplorer getInstance() {
        return singleton;
    }

    public boolean isExcludeTranslation(String en, JointPoint jointPoint) {
        PointCut pointCut;
        StackTraceElement[] stes = null;
        Set<String> noTransPathEntries = this.excludePackageProperties.getPathEntries(en);
        if (noTransPathEntries != null) {
            stes = this.getStackTrace();
            int i = 0;
            while (i < 30 && i < stes.length) {
                StackTraceElement ste = stes[i];
                String className = ste.getClassName();
                for (String noTransPath : noTransPathEntries) {
                    if (!className.startsWith(noTransPath)) continue;
                    return true;
                }
                ++i;
            }
        }
        if (jointPoint != null && (pointCut = PleiadesConfig.getInstance().getPointCut(jointPoint)) != null) {
            List<JointPoint> excludeTrace = pointCut.getExcludeTrace();
            List<JointPoint> includeTrace = pointCut.getIncludeTrace();
            if (excludeTrace.size() > 0 && this.containsTrace(excludeTrace, stes)) {
                return true;
            }
            if (includeTrace.size() > 0) {
                return !this.containsTrace(includeTrace, stes);
            }
        }
        return false;
    }

    protected boolean containsTrace(List<JointPoint> trace, StackTraceElement[] stes) {
        if (stes == null) {
            stes = this.getStackTrace();
        }
        for (JointPoint jp : trace) {
            int i = 0;
            while (i < 30 && i < stes.length) {
                String methodName;
                StackTraceElement ste = stes[i];
                if (ste.getClassName().startsWith(jp.getClassName()) && ((methodName = jp.getMethodName()) == null || ste.getMethodName().equals(methodName))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public StackTraceElement[] getStackTrace() {
        return Thread.currentThread().getStackTrace();
    }
}

