/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.util.ConcurrentPropertySet;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationNotFoundProperties;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;

public abstract class AbstractTranslationDictionary {
    private static final Logger log = Logger.getLogger(AbstractTranslationDictionary.class);
    protected final PropertySet transProp = new ConcurrentPropertySet(200000){
        private static final int VALID_CASE_MAX_LENGTH = 10;

        public String get(Object keyObj) {
            String key = (String)keyObj;
            if (key.length() > 10) {
                key = key.toLowerCase();
            }
            return super.get(key);
        }

        public String put(String key, String value) {
            if (key.length() > 10) {
                key = key.toLowerCase();
            }
            return super.put(key, value);
        }
    };
    protected final Set<String> transHelpExcludeSet = Collections.synchronizedSet(new HashSet());
    protected volatile boolean isLoadedDefault;
    private volatile boolean isLoadedHelp;
    private final TranslationNotFoundProperties notFoundLog = TranslationNotFoundProperties.getInstance();

    protected AbstractTranslationDictionary() {
        this.load();
    }

    protected synchronized boolean load() {
        File convFile;
        if (this.isLoadedDefault) {
            return false;
        }
        this.transProp.load(AbstractTranslationDictionary.validateExists("translation.properties"));
        this.transProp.load(AbstractTranslationDictionary.validateExists("translation-multibytes-key.properties"));
        File addDir = Files.getFile("additions");
        if (addDir.exists()) {
            PropertySet addProp = new PropertySet(new File[]{addDir}){

                public String put(String en, String ja) {
                    en = TranslationString.trim(Mnemonics.removeEnMnemonic(en));
                    ja = TranslationString.trim(Mnemonics.removeJaMnemonic(ja));
                    return super.put(en, ja);
                }
            };
            this.transProp.putAll(addProp);
        }
        if ((convFile = Files.getFile("translation-converter.properties")).exists()) {
            PropertySet convMap = new PropertySet(convFile);
            for (Property p : this.transProp) {
                String resultValue = p.value;
                for (Property conv : convMap) {
                    resultValue = resultValue.replaceAll(conv.key, conv.value);
                }
                if (p.value.equals(resultValue)) continue;
                this.transProp.put(p.key, resultValue);
            }
        }
        this.isLoadedDefault = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadHelp() {
        if (this.isLoadedHelp) {
            return false;
        }
        Class<AbstractTranslationDictionary> clazz = AbstractTranslationDictionary.class;
        synchronized (AbstractTranslationDictionary.class) {
            block6: {
                if (!this.isLoadedHelp) break block6;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            for (Property p : new PropertySet(AbstractTranslationDictionary.validateExists("translation-help-unchecked.properties"))) {
                if (this.transProp.containsKey(p.key)) continue;
                this.transProp.put(p);
            }
            this.transHelpExcludeSet.addAll(new PropertySet(AbstractTranslationDictionary.validateExists("translation-help-exclude.properties")).keySet());
            this.isLoadedHelp = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    public static File validateExists(String fileName) {
        File propFile = Files.getFile(fileName);
        if (!propFile.exists()) {
            String msg = String.valueOf(propFile.getName()) + " \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            log.fatal(msg, new Object[0]);
            FileNotFoundException e = new FileNotFoundException(propFile.getPath());
            throw new IllegalStateException(msg, e);
        }
        return propFile;
    }

    protected String getValue(String en) {
        if (en.length() == 0) {
            return en;
        }
        String ja = (String)this.transProp.get(en);
        if (ja != null) {
            return ja;
        }
        TranslationString enTs = new TranslationString(en);
        ja = this.getValueByRegex(enTs);
        if (ja != null) {
            this.transProp.put(en, ja);
            return ja;
        }
        ja = this.getValueToTrim(enTs);
        if (ja != null) {
            this.transProp.put(en, ja);
            return ja;
        }
        List<TranslationString> enPartTsList = enTs.split();
        if (enPartTsList == null) {
            this.notFoundLog.println(enTs.trim());
            this.transProp.put(en, en);
            return en;
        }
        boolean containsNoTransPart = false;
        StringBuilder sb = new StringBuilder();
        for (TranslationString enPartTs : enPartTsList) {
            String enPartTrim = enPartTs.trim();
            String jaPart = this.getValueToTrim(enPartTs);
            if (jaPart == null) {
                containsNoTransPart = true;
                this.notFoundLog.println(enPartTrim);
                jaPart = enPartTs.toString();
            }
            sb.append(jaPart);
        }
        ja = enTs.revert(sb.toString());
        if (containsNoTransPart) {
            this.notFoundLog.println(enTs.trim());
        }
        this.transProp.put(en, ja);
        return ja;
    }

    protected String getValueToTrim(TranslationString enTs) {
        String enTrim = enTs.trim();
        if (enTrim.length() == 0) {
            return enTs.toString();
        }
        String ja = (String)this.transProp.get(enTrim);
        if (ja != null) {
            return enTs.revert(ja);
        }
        ja = (String)this.transProp.get(enTrim = TranslationString.removeS(enTrim));
        if (ja != null) {
            return enTs.revert(ja);
        }
        enTrim = enTrim.replaceAll("(?s)(<a[^>]*>)'+", "$1");
        ja = (String)this.transProp.get(enTrim = enTrim.replaceAll("(?s)'+(</a>)", "$1"));
        if (ja != null) {
            return enTs.revert(ja);
        }
        String enTrimForce = enTs.trimForce();
        ja = (String)this.transProp.get(enTrimForce);
        if (ja != null) {
            return enTs.revert(ja);
        }
        return null;
    }

    protected String getValueByRegex(TranslationString enTs) {
        String ja = RegexDictionary.getInstance().lookup(enTs.trim());
        if (ja != null) {
            return enTs.revert(ja);
        }
        return null;
    }

    protected String getValueForHelp(String en) {
        if (this.transHelpExcludeSet.contains(en)) {
            return en;
        }
        this.loadHelp();
        String ja = this.getValue(en);
        return ja;
    }
}

