/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DynamicTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.UnderscoreMnemonicDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.lang.StringUtils;

public class TraceableTranslationDictionary
extends UnderscoreMnemonicDictionary {
    private static final Logger log = Logger.getLogger(TraceableTranslationDictionary.class);
    private static String tracePattern;
    private static Boolean traceIsJa;

    public static TraceableTranslationDictionary getInstance() {
        PleiadesConfig config = PleiadesConfig.getInstance();
        tracePattern = config.getProperty("trace.pattern");
        if (StringUtils.isNotEmpty((String)tracePattern)) {
            traceIsJa = Boolean.valueOf(config.getProperty("trace.is.ja"));
            log.warn("\u30c8\u30ec\u30fc\u30b9\u7ffb\u8a33\u8f9e\u66f8\u3092\u751f\u6210\u3057\u307e\u3059\u3002tracePattern=%s, traceIsJa=%s", tracePattern, traceIsJa);
            return new TraceableTranslationDictionary();
        }
        return null;
    }

    private TraceableTranslationDictionary() {
    }

    protected String lookupInternal(String en, JointPoint jointPoint) {
        String target;
        String ja = super.lookupInternal(en, jointPoint);
        String string = target = traceIsJa != false ? ja : en;
        if (target.matches(tracePattern)) {
            String s = String.valueOf(System.currentTimeMillis()) + "\u300c" + en + "\u300d\u2192\u300c" + ja + "\u300d";
            log.debug(new Exception(s), "\u30c7\u30d0\u30c3\u30b0\u7ffb\u8a33\u8ffd\u8de1\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9 jointPoint:" + jointPoint, new Object[0]);
            return s;
        }
        return ja;
    }

    public static /* bridge */ /* synthetic */ DynamicTranslationDictionary getInstance() {
        return TraceableTranslationDictionary.getInstance();
    }
}

