/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.AbstractTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

public class RegexDictionary {
    private static final Logger log = Logger.getLogger(RegexDictionary.class);
    private static final RegexDictionary singleton = new RegexDictionary();
    private static final int REGEX_MAP_CAPACITY = 1000;
    private final Map<Pattern, String> regexMap = new HashMap<Pattern, String>(1000);
    private static final int REGEX_THROUGH_SET_CAPACITY = 100;
    private final Set<Pattern> regexThroughSet = new HashSet<Pattern>(100);

    public static RegexDictionary getInstance() {
        return singleton;
    }

    private RegexDictionary() {
        File file = AbstractTranslationDictionary.validateExists("translation-regex.properties");
        for (Property p : new PropertySet(1000).load(file)) {
            this.regexMap.put(Pattern.compile(p.key), p.value);
        }
        file = AbstractTranslationDictionary.validateExists("translation-regex-through.properties");
        for (Property p : new PropertySet(100).load(file)) {
            this.regexThroughSet.add(Pattern.compile(p.key));
        }
    }

    public String lookup(String en) {
        for (Map.Entry<Pattern, String> entry : this.regexMap.entrySet()) {
            Pattern pattern = entry.getKey();
            Matcher matcher = pattern.matcher(en);
            try {
                if (!matcher.matches()) continue;
                String replacement = entry.getValue();
                return matcher.replaceFirst(replacement);
            }
            catch (RuntimeException e) {
                log.error(e, "\u6b63\u898f\u8868\u73fe\u7ffb\u8a33\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + pattern, new Object[0]);
                break;
            }
        }
        for (Pattern pattern : this.regexThroughSet) {
            Matcher matcher = pattern.matcher(en);
            if (!matcher.matches()) continue;
            return en;
        }
        return null;
    }
}

