/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.advice;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PleiadesConfigAssembler
extends DefaultHandler {
    private static final Logger log = Logger.getLogger(PleiadesConfigAssembler.class);
    protected final Map<String, String> propertyMap = new HashMap<String, String>();
    protected final Set<String> excludePackageSet = new HashSet<String>();
    protected final Map<JointPoint, PointCut> jointMap = new HashMap<JointPoint, PointCut>();
    private PointCut pointCut;
    private StringBuilder elementBodyBuffer;
    private JointPoint jointPoint;
    private String editPoint;

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!qName.equals("pleiades")) {
            if (qName.equals("property")) {
                String name = attributes.getValue("name");
                String value = this.replacePropertyVariables(attributes.getValue("value"));
                this.propertyMap.put(name, value);
            } else if (qName.equals("pointCut")) {
                this.pointCut = new PointCut();
                this.pointCut.setTiming(attributes.getValue("timing"));
                this.pointCut.setLevel(attributes.getValue("level"));
                this.editPoint = attributes.getValue("editPoint");
            } else if (qName.equals("advice") || qName.equals("excludePackage")) {
                this.elementBodyBuffer = new StringBuilder();
            } else if (qName.equals("jointPoint")) {
                this.jointPoint = this.createJointPoint(new JointPoint(), attributes);
                if (this.jointMap.containsKey(this.jointPoint)) {
                    log.warn("\u30b8\u30e7\u30a4\u30f3\u30c8\u30fb\u30dd\u30a4\u30f3\u30c8\u5b9a\u7fa9\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002" + this.jointPoint, new Object[0]);
                }
                PointCut curPointCut = new PointCut(this.pointCut);
                this.jointMap.put(this.jointPoint, curPointCut);
                curPointCut.setJointPoint(this.jointPoint);
            } else if (qName.endsWith("cludeWhere")) {
                PointCut curPointCut = this.jointMap.get(this.jointPoint);
                if (curPointCut.getJointPoint().getEditPoint() == JointPoint.EditPoint.EXECUTION) {
                    throw new IllegalStateException("editPoint \u304c execution \u306e\u5834\u5408\u3001*cludeWhere \u5c5e\u6027\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + curPointCut);
                }
                JointPoint where = this.createJointPoint(new JointPoint(), attributes);
                if (qName.equals("excludeWhere")) {
                    curPointCut.getExcludeWheres().add(where);
                } else if (qName.equals("includeWhere")) {
                    curPointCut.getIncludeWheres().add(where);
                } else {
                    throw new IllegalStateException("\u4e0d\u6b63\u306a\u5c5e\u6027\u540d\u3067\u3059\u3002" + qName);
                }
                if (curPointCut.getExcludeWheres().size() > 0 && curPointCut.getIncludeWheres().size() > 0) {
                    throw new IllegalStateException("\u540c\u3058 jointPoint \u5185\u306b excludeWhere \u3068 includeWhere \u3092\u540c\u6642\u306b\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002" + curPointCut);
                }
            } else if (qName.endsWith("cludeTrace")) {
                PointCut curPointCut = this.jointMap.get(this.jointPoint);
                if (curPointCut.getJointPoint().getEditPoint() == JointPoint.EditPoint.CALL) {
                    throw new IllegalStateException("editPoint \u304c call \u306e\u5834\u5408\u3001*cludeTrace \u5c5e\u6027\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + curPointCut);
                }
                if (!curPointCut.getAdvice().contains("?{JOINT_POINT}")) {
                    throw new IllegalStateException("*cludeTrace \u3092\u6307\u5b9a\u3057\u3066\u3044\u308b\u5834\u5408\u306f Advice \u306b ?{JOINT_POINT} \u304c\u542b\u307e\u308c\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" + curPointCut);
                }
                JointPoint where = this.createJointPoint(new JointPoint(), attributes);
                if (qName.equals("excludeTrace")) {
                    curPointCut.getExcludeTrace().add(where);
                } else if (qName.equals("includeTrace")) {
                    curPointCut.getIncludeTrace().add(where);
                } else {
                    throw new IllegalStateException("\u4e0d\u6b63\u306a\u5c5e\u6027\u540d\u3067\u3059\u3002" + qName);
                }
                if (curPointCut.getExcludeTrace().size() > 0 && curPointCut.getIncludeTrace().size() > 0) {
                    throw new IllegalStateException("\u540c\u3058 jointPoint \u5185\u306b excludeTrace \u3068 includeTrace \u3092\u540c\u6642\u306b\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002" + curPointCut);
                }
            } else {
                throw new IllegalStateException("\u4e0d\u6b63\u306a\u5c5e\u6027\u540d\u3067\u3059\u3002" + qName);
            }
        }
    }

    private JointPoint createJointPoint(JointPoint jointPoint, Attributes attributes) {
        jointPoint.setEditPoint(this.editPoint);
        jointPoint.setClassName(attributes.getValue("className"));
        jointPoint.setMethodName(attributes.getValue("methodName"));
        String descriptor = attributes.getValue("descriptor");
        jointPoint.setDescriptor(descriptor);
        if (descriptor != null && descriptor.matches(".+[a-z]\\).+")) {
            throw new IllegalStateException("descriptor \u306b\u6307\u5b9a\u3059\u308b\u578b\u306e\u672b\u5c3e\u306b\u306f ; \u304c\u5fc5\u8981\u3067\u3059\u3002" + jointPoint);
        }
        return jointPoint;
    }

    private String replacePropertyVariables(String value) {
        for (Map.Entry<String, String> e : this.propertyMap.entrySet()) {
            value = value.replaceAll("\\?\\{" + e.getKey() + "\\}", e.getValue());
        }
        return value;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("advice")) {
            String advice = this.replacePropertyVariables(this.elementBodyBuffer.toString());
            this.pointCut.setAdvice(advice);
        } else if (qName.equals("excludePackage")) {
            String excludePackage = this.elementBodyBuffer.toString().replaceAll("(?s)<!--.*-->", "");
            List<String> list = Arrays.asList(excludePackage.trim().split("\\s+"));
            this.excludePackageSet.addAll(list);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elementBodyBuffer != null) {
            this.elementBodyBuffer.append(ch, start, length);
        }
    }
}

