/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

public class Mnemonics {
    private static final String MNEMONIC_CHARS = "[\\w\\.@]";

    private Mnemonics() {
    }

    public static String removeJaMnemonic(String ja) {
        if (Mnemonics.hasJaMnemonic(ja)) {
            ja = ja.replaceFirst("\\(\\&[\\w\\.@]\\)", "");
            ja = ja.replaceFirst("\\(\\&\\)", "");
        }
        return ja;
    }

    public static String removeEnMnemonic(String en) {
        if (Mnemonics.hasEnMnemonic(en)) {
            return en.replaceFirst("\\&([\\w\\.@])", "$1");
        }
        return en;
    }

    public static boolean hasJaMnemonic(String value) {
        return value.contains("(&") && value.matches("(?s)^.*?\\(\\&[\\w\\.@]\\).*$");
    }

    public static boolean hasEnMnemonic(String value) {
        return value.contains("&") && !value.contains("& ") && !value.contains("&&&") && !Mnemonics.containsHtmlReference(value) && !Mnemonics.containsUrlParameters(value);
    }

    public static boolean containsHtmlReference(String value) {
        return value.contains("&lt;") || value.contains("&gt;") || value.contains("&amp;") || value.contains("&quot;") || value.contains("&yen;") || value.contains("&nbsp;");
    }

    public static boolean containsUrlParameters(String value) {
        return !value.contains("? ") && !value.contains("?=") && value.contains("?") && value.contains("=") && value.contains("&");
    }

    public static String convertMnemonicEnToJa(String enWithMnemonic, String en, String ja) {
        if (enWithMnemonic.length() == en.length()) {
            return ja;
        }
        if (ja.contains("&") && !ja.contains("&&")) {
            return ja;
        }
        String mnemonicChar = enWithMnemonic.replaceFirst("(?s)^.*?\\&([\\w\\.@]).*$", "$1");
        if (mnemonicChar.length() != 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Mnemonic invalid length:" + mnemonicChar.length());
            sb.append(", enValue:" + enWithMnemonic);
            sb.append(", enValueNonMnemonic:" + en);
            sb.append(", mnemonicChar:" + mnemonicChar);
            throw new IllegalArgumentException(sb.toString());
        }
        String mnemonicJa = "(&" + mnemonicChar.toUpperCase() + ")";
        String jaWithMnemonic = ja.replaceFirst("(?s)^('.+?|.+?)((\\s*\\.{3,4}|)@\\p{ASCII}+|\\.{3,4}(</a>|)\\s*|\\s*|:\\s*|:\\s+\\{[0-9]\\}\\s*|(:|)\\s+\\(.+\\)\\s*|\\s+(-*|)>+\\s*)$", "$1" + mnemonicJa + "$2");
        return jaWithMnemonic;
    }
}

