/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.LinkedList;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.aspect.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.aspect.AsyncCommand;
import jp.sourceforge.mergedoc.pleiades.aspect.AsyncQueue;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherEclipseTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.Locks;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PleiadesConfig;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.CacheFiles;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DynamicTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.ExcludeClassNameCache;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.ExcludePackageProperties;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TransformedClassCache;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.lang.ArrayUtils;

public class LauncherTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(LauncherTransformer.class);
    private static final String THIS_CLASS = LauncherTransformer.class.getName();
    protected static volatile TransformedClassCache transformedClassCache;
    private static LauncherTransformer thisInstance;
    private static final String CLEAN_OPTION_STRING = "-clean";

    public LauncherTransformer() {
        thisInstance = this;
        this.init();
    }

    protected void init() {
        long start = System.nanoTime();
        PleiadesConfig.getInstance();
        AsyncQueue.add(new AsyncCommand("\u7ffb\u8a33\u9664\u5916\u30d1\u30c3\u30b1\u30fc\u30b8\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306e\u30ed\u30fc\u30c9"){

            public void execute() {
                ExcludePackageProperties.getInstance();
            }
        });
        AsyncQueue.add(new AsyncCommand("\u6b63\u898f\u8868\u73fe\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306e\u30ed\u30fc\u30c9"){

            public void execute() {
                RegexDictionary.getInstance();
            }
        });
        Analyses.end(LauncherTransformer.class, "init", start);
    }

    protected byte[] transform(String classId, String className, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        if (className.startsWith("jp.sourceforge.mergedoc.")) {
            return null;
        }
        try {
            CtClass clazz = this.createCtClass(bytecode);
            CtMethod main = clazz.getMethod("main", "([Ljava/lang/String;)V");
            main.insertBefore("$1 = " + THIS_CLASS + ".start($$);" + THIS_CLASS + ".shutdownLauncherProcess();" + THIS_CLASS + ".addShutdownHook();");
            byte[] byArray = clazz.toBytecode();
            return byArray;
        }
        finally {
            LauncherTransformer.removeTransformer();
        }
    }

    protected void handleException(Throwable e, String msg) {
        log.error(e, msg, new Object[0]);
    }

    protected static void removeTransformer() {
        log.info("Pleiades AOP \u8d77\u52d5\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u3092\u505c\u6b62\u3057\u307e\u3059\u3002", new Object[0]);
        Pleiades.getInstrumentation().removeTransformer(thisInstance);
    }

    protected static String[] startTranslationTransformer(String ... args) {
        long start = System.nanoTime();
        try {
            File excludeList;
            PleiadesOption option = Pleiades.getPleiadesOption();
            LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
            boolean isIncludeArgsClean = argList.contains(CLEAN_OPTION_STRING);
            if (!option.isClean) {
                option.isClean = isIncludeArgsClean;
            }
            if (!option.isClean && !(excludeList = Pleiades.getResourceFile(CacheFiles.EXCLUDE_CLASS_LIST)).exists()) {
                log.info("\u5909\u63db\u9664\u5916\u30af\u30e9\u30b9\u540d\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5b58\u5728\u3057\u306a\u3044\u305f\u3081\u3001\u5f37\u5236\u7684\u306b -clean \u30e2\u30fc\u30c9\u3067\u8d77\u52d5\u3057\u307e\u3059\u3002", new Object[0]);
                option.isClean = true;
            }
            log.info("\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u8d77\u52d5\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002-clean:" + option.isClean, new Object[0]);
            if (option.isClean) {
                CacheFiles.clear();
                if (!isIncludeArgsClean) {
                    argList.add(CLEAN_OPTION_STRING);
                }
            } else {
                LauncherTransformer.removeTransformer();
            }
            Locks.lock();
            AsyncQueue.add(new AsyncCommand("\u30ea\u30bd\u30fc\u30b9\u306e\u30ed\u30fc\u30c9"){

                public void execute() {
                    try {
                        ExcludeClassNameCache.getInstance();
                        transformedClassCache = TransformedClassCache.getInstance();
                        DynamicTranslationDictionary.getInstance();
                    }
                    finally {
                        Locks.release();
                    }
                }
            });
            log.info("Pleiades AOP \u7ffb\u8a33\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u3092\u958b\u59cb\u3057\u307e\u3059\u3002", new Object[0]);
            Instrumentation inst = Pleiades.getInstrumentation();
            inst.addTransformer(new TranslationTransformer());
            String[] stringArray = argList.toArray(new String[argList.size()]);
            return stringArray;
        }
        catch (Throwable e) {
            String msg = "Pleiades AOP \u7ffb\u8a33\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            log.fatal(msg, new Object[0]);
            throw new IllegalStateException(msg, e);
        }
        finally {
            Analyses.end(LauncherEclipseTransformer.class, "startTranslationTransformer", start);
        }
    }

    public static String[] start(String ... args) {
        LauncherTransformer.startTranslationTransformer(args);
        String[] newArgs = (String[])ArrayUtils.removeElement((Object[])args, (Object)CLEAN_OPTION_STRING);
        return newArgs;
    }

    public static void shutdownLauncherProcess() {
        AsyncQueue.add(new AsyncCommand("\u975e\u540c\u671f\u30ad\u30e5\u30fc\u306e\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3"){

            public void execute() throws Exception {
                AsyncQueue.shutdown();
            }
        });
    }

    public static void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                LauncherTransformer.shutdown();
            }
        });
        new Frame().pack();
    }

    public static void shutdown() {
        new Thread("pleiades-shutdown"){

            public void run() {
                if (log.isDebugEnabled()) {
                    Analyses.flashLog("Eclipse \u7d42\u4e86\u3002", new Object[0]);
                }
                try {
                    try {
                        Locks.lock();
                        TransformedClassCache.getInstance().shutdown();
                        ExcludeClassNameCache.getInstance().shutdown();
                        DynamicTranslationDictionary.getInstance().shutdown();
                    }
                    catch (Exception e) {
                        log.warn(e, "\u30ad\u30e3\u30c3\u30b7\u30e5\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
                        Locks.release();
                        AsyncQueue.shutdown();
                        if (Pleiades.getPleiadesOption().isPreload()) {
                            System.exit(0);
                        }
                    }
                }
                finally {
                    Locks.release();
                    AsyncQueue.shutdown();
                    if (Pleiades.getPleiadesOption().isPreload()) {
                        System.exit(0);
                    }
                }
            }
        }.start();
    }

    public static void debug(Object o) {
        log.debug(String.valueOf(o), new Object[0]);
    }
}

