/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.aspect.AsyncCommand;
import jp.sourceforge.mergedoc.pleiades.aspect.AsyncQueue;
import jp.sourceforge.mergedoc.pleiades.aspect.CleanMessage;
import jp.sourceforge.mergedoc.pleiades.aspect.EclipseFiles;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.Metadata;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import org.apache.commons.lang.ArrayUtils;

public class LauncherEclipseTransformer
extends LauncherTransformer {
    private static final Logger log = Logger.getLogger(LauncherEclipseTransformer.class);
    private static final String THIS_CLASS = LauncherEclipseTransformer.class.getName();
    private static volatile boolean showWorkspaceSelectionDialog = true;
    private volatile int transformedClassCount;

    protected void init() {
        long start = System.nanoTime();
        AsyncQueue.add(new AsyncCommand("\u30b3\u30a2\u30fb\u30d7\u30e9\u30b0\u30a4\u30f3\u3092 Javassist \u30af\u30e9\u30b9\u30d1\u30b9\u3078\u8ffd\u52a0"){

            public void execute() throws Exception {
                File plugins = new File(EclipseFiles.getOsgiHome(), "plugins");
                Object[] jars = plugins.listFiles(Files.createSuffixFilter(".jar"));
                Arrays.sort(jars);
                ArrayUtils.reverse((Object[])jars);
                HashSet<String> pluginSuffixSet = new HashSet<String>();
                Object[] objectArray = jars;
                int n = jars.length;
                int n2 = 0;
                while (n2 < n) {
                    Object jar = objectArray[n2];
                    String jarFileName = ((File)jar).getName();
                    String pluginSuffix = jarFileName.replaceFirst("^(.+_).+$", "$1");
                    if (!pluginSuffixSet.contains(pluginSuffix)) {
                        pluginSuffixSet.add(pluginSuffix);
                        String jarFullPath = ((File)jar).getCanonicalPath().replace('\\', '/');
                        LauncherEclipseTransformer.this.addClassPath(jarFullPath, jarFileName);
                    }
                    ++n2;
                }
            }
        });
        final PleiadesOption option = Pleiades.getPleiadesOption();
        if (!option.isClean) {
            AsyncQueue.addAwait(new AsyncCommand("\u30d7\u30e9\u30b0\u30a4\u30f3\u6700\u7d42\u66f4\u65b0\u6642\u523b\u306e\u5224\u5b9a"){

                public void execute() throws Exception {
                    if (EclipseFiles.isPluginUpdated()) {
                        option.isClean = true;
                        log.info("Eclipse \u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u66f4\u65b0\u304c\u691c\u51fa\u3055\u308c\u305f\u305f\u3081\u3001\u5f37\u5236\u7684\u306b -clean \u30e2\u30fc\u30c9\u3067\u8d77\u52d5\u3057\u307e\u3059\u3002", new Object[0]);
                    }
                }
            });
        }
        super.init();
        AsyncQueue.add(new AsyncCommand("Eclipse \u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u53d6\u5f97"){

            public void execute() {
                EclipseFiles.getVersion();
            }
        });
        AsyncQueue.add(new AsyncCommand("\u59cb\u52d5\u6642\u306e\u30ef\u30fc\u30af\u30b9\u30da\u30fc\u30b9\u30fb\u30c0\u30a4\u30a2\u30ed\u30b0\u8868\u793a\u6709\u7121\u53d6\u5f97"){

            public void execute() {
                File prefs = Pleiades.getResourceFile("../.settings/org.eclipse.ui.ide.prefs");
                if (prefs.exists()) {
                    PropertySet p = new PropertySet(prefs);
                    showWorkspaceSelectionDialog = Boolean.valueOf((String)p.get("SHOW_WORKSPACE_SELECTION_DIALOG"));
                }
            }
        });
        Analyses.end(LauncherEclipseTransformer.class, "init", start);
    }

    protected byte[] transform(String classId, String className, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        if (!className.startsWith("org.eclipse.")) {
            return null;
        }
        byte[] transformedBytecode = null;
        if (className.endsWith(".launcher.Main")) {
            log.info("transform: " + className, new Object[0]);
            try {
                CtClass clazz = this.createCtClass(bytecode);
                CtMethod basicRun = clazz.getMethod("basicRun", "([Ljava/lang/String;)V");
                basicRun.insertBefore("$1 = " + THIS_CLASS + ".start($$);");
                CtMethod getSplashLocation = clazz.getMethod("getSplashLocation", "([Ljava/net/URL;)Ljava/lang/String;");
                getSplashLocation.insertAfter(String.valueOf(THIS_CLASS) + ".showCleanMessage($_);");
                return clazz.toBytecode();
            }
            catch (NotFoundException e) {
                if (className.equals("org.eclipse.core.launcher.Main")) {
                    return null;
                }
                throw e;
            }
        }
        if (className.equals("org.eclipse.ui.internal.ide.application.IDEWorkbenchAdvisor")) {
            log.info("transform: " + className, new Object[0]);
            ++this.transformedClassCount;
            CtClass clazz = this.createCtClass(bytecode);
            clazz.getDeclaredConstructor(null).insertBefore("org.eclipse.osgi.service.datalocation.Location loc = null;loc = org.eclipse.core.runtime.Platform.getInstanceLocation();java.net.URL workspace = null;if (loc != null) workspace = loc.getURL();" + Metadata.class.getName() + ".getInstance().createNewWorkspaceMetadata(workspace);");
            transformedBytecode = clazz.toBytecode();
        } else if (className.equals("org.eclipse.ui.internal.Workbench")) {
            log.info("transform: " + className, new Object[0]);
            ++this.transformedClassCount;
            CtClass clazz = this.createCtClass(bytecode);
            CtMethod shutdown = clazz.getMethod("shutdown", "()V");
            shutdown.insertBefore(String.valueOf(THIS_CLASS) + ".shutdown();");
            CtMethod addStartup = clazz.getMethod("addStartupRegistryListener", "()V");
            addStartup.insertAfter(String.valueOf(THIS_CLASS) + ".onWorkbenchCreationComplete($0);");
            transformedBytecode = clazz.toBytecode();
        } else if (className.equals("org.eclipse.ui.splash.BasicSplashHandler$AbsolutePositionProgressMonitorPart")) {
            log.info("transform: " + className, new Object[0]);
            ++this.transformedClassCount;
            String eclipseVersion = EclipseFiles.getVersion();
            if (eclipseVersion.matches("4\\.[0-3]")) {
                CtClass clazz = this.createCtClass(bytecode);
                CtMethod getBundleCount = clazz.getMethod("internalWorked", "(D)V");
                getBundleCount.insertBefore("$1 *= 4;");
                transformedBytecode = clazz.toBytecode();
            }
        } else if (className.equals("org.eclipse.core.resources.ResourcesPlugin")) {
            log.info("transform: " + className, new Object[0]);
            ++this.transformedClassCount;
            CtClass clazz = this.createCtClass(bytecode);
            CtMethod method = clazz.getMethod("getPlugin", "()Lorg/eclipse/core/resources/ResourcesPlugin;");
            method.insertAfter("String enc = " + Metadata.class.getName() + ".getInstance().getDefaultWorkspaceEncoding();" + "if (enc != null) " + "\t$_.getPluginPreferences().setValue(\"encoding\", enc);");
            transformedBytecode = clazz.toBytecode();
        } else if (className.equals("org.eclipse.ui.internal.WorkbenchWindow")) {
            log.info("transform: " + className, new Object[0]);
            ++this.transformedClassCount;
            try {
                CtClass clazz = this.createCtClass(bytecode);
                CtMethod restore = clazz.getMethod("restoreState", "(Lorg/eclipse/ui/IMemento;Lorg/eclipse/ui/IPerspectiveDescriptor;)Lorg/eclipse/core/runtime/IStatus;");
                restore.insertBefore(String.valueOf(THIS_CLASS) + ".setWindowPosition($1);");
                transformedBytecode = clazz.toBytecode();
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (transformedBytecode != null && transformedClassCache != null) {
            transformedClassCache.putNextLaunch(classId, transformedBytecode);
        }
        if (this.transformedClassCount == 5) {
            LauncherEclipseTransformer.removeTransformer();
        }
        return transformedBytecode;
    }

    public static String[] start(String ... args) {
        AsyncQueue.awaitTermination();
        String[] newArgs = LauncherTransformer.startTranslationTransformer(args);
        if (!Pleiades.getPleiadesOption().isDefaultSplash) {
            AsyncQueue.add(new AsyncCommand("\u30b9\u30d7\u30e9\u30c3\u30b7\u30e5\u753b\u50cf\u30d1\u30b9\u306e\u8a2d\u5b9a"){

                public void execute() {
                    String splashLocation = LauncherEclipseTransformer.getSplashLocation();
                    if (splashLocation != null) {
                        log.debug("\u30b9\u30d7\u30e9\u30c3\u30b7\u30e5\u30fb\u30ed\u30b1\u30fc\u30b7\u30e7\u30f3: %s", splashLocation);
                        System.setProperty("osgi.splashLocation", splashLocation);
                    }
                }
            });
        }
        return newArgs;
    }

    public static void showCleanMessage(String splashLocation) {
        if (Pleiades.getPleiadesOption().isClean) {
            CleanMessage.show(splashLocation);
        }
    }

    public static void onWorkbenchCreationComplete(final Object workbench) throws Exception {
        PleiadesOption option = Pleiades.getPleiadesOption();
        if (option.isClean) {
            AsyncQueue.add(new AsyncCommand("\u30af\u30ea\u30fc\u30f3\u30fb\u30b9\u30d7\u30e9\u30c3\u30b7\u30e5\u306e\u30af\u30ed\u30fc\u30ba"){

                public void execute() {
                    CleanMessage.close();
                }
            });
        }
        if (log.isDebugEnabled()) {
            AsyncQueue.add(new AsyncCommand("\u5b9f\u884c\u6642\u30b7\u30b9\u30c6\u30e0\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306e\u4fdd\u7ba1"){

                public void execute() {
                    PropertySet systemProp = new PropertySet(System.getProperties());
                    File file = Pleiades.getResourceFile("system.properties");
                    systemProp.store(file, "\u5b9f\u884c\u6642\u30b7\u30b9\u30c6\u30e0\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
                }
            });
        }
        if (option.isPreload()) {
            AsyncQueue.add(new AsyncCommand("\u30d7\u30ea\u30ed\u30fc\u30c9\u81ea\u52d5\u7d42\u4e86\u547c\u3073\u51fa\u3057"){

                public void execute() throws Exception {
                    Method close = workbench.getClass().getMethod("close", new Class[0]);
                    close.invoke(workbench, new Object[0]);
                }
            });
        }
        long startTime = Long.valueOf(System.getProperty("eclipse.startTime"));
        long curTime = System.currentTimeMillis();
        double startupTime = (double)(curTime - startTime) / 1000.0;
        String message = String.format("Eclipse \u59cb\u52d5\u5b8c\u4e86 - \u59cb\u52d5\u6642\u9593: %.3f \u79d2", startupTime);
        Analyses.flashLog(String.valueOf(message) + "\u3002-clean:" + option.isClean, new Object[0]);
        if (!showWorkspaceSelectionDialog) {
            try {
                Method getActivatedWindow = workbench.getClass().getDeclaredMethod("getActivatedWindow", new Class[0]);
                getActivatedWindow.setAccessible(true);
                Object workbenchWindow = getActivatedWindow.invoke(workbench, new Object[0]);
                Method setStatus = workbenchWindow.getClass().getMethod("setStatus", String.class);
                setStatus.invoke(workbenchWindow, message);
            }
            catch (NoSuchMethodException e) {
                log.debug("E4 \u306e\u305f\u3081\u30b9\u30c6\u30fc\u30bf\u30b9\u30d0\u30fc\u306b\u59cb\u52d5\u6642\u9593\u3092\u8868\u793a\u3057\u307e\u305b\u3093\u3002", new Object[0]);
            }
        }
        LauncherEclipseTransformer.shutdownLauncherProcess();
    }

    public static void setWindowPosition(Object memento) throws Exception {
        if (Pleiades.getPleiadesOption().isPreload()) {
            Method putInteger = memento.getClass().getMethod("putInteger", String.class, Integer.TYPE);
            putInteger.invoke(memento, "width", 200);
            putInteger.invoke(memento, "x", -199);
        }
    }

    public static String getSplashLocation() {
        File home = EclipseFiles.getHome();
        if (!new File(home, "eclipse.exe").exists() && !new File(home, "eclipse").exists()) {
            return null;
        }
        File customFile = Files.getFile("../../../splash.bmp");
        if (customFile.exists()) {
            return customFile.getAbsolutePath().replace('\\', '/');
        }
        String fileName = "splash" + EclipseFiles.getVersion() + ".bmp";
        File file = Files.getFile(fileName);
        if (!file.exists()) {
            file = Files.getFile("splash.bmp");
        }
        String splashLocation = file.getAbsolutePath().replace('\\', '/');
        return splashLocation;
    }
}

