/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

public class EclipseFiles {
    private static File home;
    private static File osgiHome;
    private static File pleiadesConfigurationPath;
    private static String version;

    public static void init(String configurationDir) throws IOException {
        File configIniFile = EclipseFiles.getConfigIniFile(configurationDir);
        if (configIniFile == null) {
            File configDir = new File(EclipseFiles.getSystemUserDir(), configurationDir);
            pleiadesConfigurationPath = new File(configDir, Pleiades.PACKAGE_NAME);
        } else {
            pleiadesConfigurationPath = EclipseFiles.getPleiadesConfigPath(configIniFile);
        }
        pleiadesConfigurationPath.mkdirs();
    }

    private static File getConfigIniFile(String configurationDir) {
        File eclipseDir;
        String CONFIG_INI = "config.ini";
        String CONFIG_DIR_INI = String.valueOf(configurationDir) + "/" + "config.ini";
        File configIniFile = new File(EclipseFiles.getSystemUserDir(), CONFIG_DIR_INI);
        if (configIniFile.exists()) {
            return configIniFile;
        }
        File dir = eclipseDir = Files.resourceRoot.getParentFile().getParentFile().getParentFile();
        while (dir != null) {
            configIniFile = new File(dir, CONFIG_DIR_INI);
            if (configIniFile.exists()) {
                return configIniFile;
            }
            dir = dir.getParentFile();
        }
        dir = eclipseDir;
        while (dir != null) {
            File[] fileArray = dir.listFiles(Files.createDirectoryFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File d = fileArray[n2];
                configIniFile = new File(d, "config.ini");
                if (configIniFile.exists()) {
                    return configIniFile;
                }
                ++n2;
            }
            dir = dir.getParentFile();
        }
        return null;
    }

    private static String getSystemUserDir() {
        return System.getProperty("user.dir");
    }

    private static File getPleiadesConfigPath(File configIniFile) {
        File baseDir;
        String base;
        Matcher mat;
        File jarFile;
        File configPath = configIniFile.getParentFile();
        home = configPath.getParentFile();
        PropertySet configIni = new PropertySet(configIniFile);
        String osgiJarPath = (String)configIni.get("osgi.framework");
        if (osgiJarPath != null && (jarFile = new File(osgiJarPath.replace("file:", ""))).exists()) {
            osgiHome = jarFile.getParentFile().getParentFile();
        }
        if (osgiHome == null) {
            osgiHome = home;
        }
        String CONFIG_AREA_KEY = "osgi.configuration.area";
        String configArea = (String)configIni.get("osgi.configuration.area");
        if (configArea == null) {
            configArea = System.getProperty("osgi.configuration.area");
        }
        File userConfigPath = null;
        if (configArea != null && (mat = Pattern.compile("^@([\\w\\.]+)(.+)$").matcher(configArea)).find() && (base = System.getProperty(mat.group(1))) != null && (baseDir = new File(base)).exists()) {
            String childPath = mat.group(2);
            userConfigPath = new File(baseDir, childPath);
        }
        if (userConfigPath != null) {
            return new File(userConfigPath, Pleiades.PACKAGE_NAME);
        }
        if (Pleiades.getOS() == Pleiades.OS.WINDOWS) {
            return new File(configPath, Pleiades.PACKAGE_NAME);
        }
        File base2 = new File(System.getProperty("user.home"), ".eclipse/" + Pleiades.PACKAGE_NAME);
        String instPath = home.getPath().replace("/", "-");
        return new File(base2, instPath);
    }

    public static File getHome() {
        return home;
    }

    public static File getOsgiHome() {
        return osgiHome;
    }

    public static File getPleiadesConfigurationPath() {
        return pleiadesConfigurationPath;
    }

    public static synchronized String getVersion() {
        if (version != null) {
            return version;
        }
        version = "";
        if (osgiHome == null) {
            return version;
        }
        File featuresFolder = new File(osgiHome, "features");
        if (!featuresFolder.exists()) {
            return version;
        }
        File[] fileArray = featuresFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            String folderName = folder.getName();
            if (folderName.startsWith("org.eclipse.platform_")) {
                version = folderName.replaceFirst(".*?_(\\d+\\.\\d+).*", "$1");
                break;
            }
            ++n2;
        }
        return version;
    }

    public static boolean isPluginUpdated() throws IOException {
        long prevLastModified;
        long start = System.nanoTime();
        File pluginModifiedFile = new File(pleiadesConfigurationPath, ".plugin-modified");
        long lastModified = prevLastModified = pluginModifiedFile.lastModified();
        lastModified = EclipseFiles.getLastModified(new File(osgiHome, "plugins"), lastModified);
        lastModified = EclipseFiles.getLastModified(new File(osgiHome, "dropins"), lastModified);
        Logger log = Logger.getLogger(EclipseFiles.class);
        log.info("\u524d\u56de\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u66f4\u65b0\u6700\u7d42\u6642\u523b: %tF %tT", prevLastModified, prevLastModified);
        log.info("\u4eca\u56de\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u66f4\u65b0\u6700\u7d42\u6642\u523b: %tF %tT", lastModified, lastModified);
        boolean isUpdated = false;
        if (lastModified > prevLastModified) {
            pluginModifiedFile.createNewFile();
            pluginModifiedFile.setLastModified(lastModified);
            isUpdated = true;
        }
        Analyses.end(EclipseFiles.class, "isPluginUpdated", start);
        return isUpdated;
    }

    private static long getLastModified(File parentDir, long latest) {
        long modified;
        if (!parentDir.exists()) {
            return latest;
        }
        String parentName = parentDir.getName();
        if (parentName.equals("features")) {
            return latest;
        }
        boolean isParentPluginsDir = parentName.equals("plugins");
        File[] fileArray = parentDir.listFiles(Files.createDirectoryFilter());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (isParentPluginsDir) {
                modified = dir.lastModified();
                if (modified > latest) {
                    latest = modified;
                }
            } else {
                latest = EclipseFiles.getLastModified(dir, latest);
            }
            ++n2;
        }
        if (isParentPluginsDir) {
            fileArray = parentDir.listFiles(Files.createSuffixFilter(".jar"));
            n = fileArray.length;
            n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                modified = file.lastModified();
                if (modified > latest) {
                    latest = modified;
                }
                ++n2;
            }
        }
        return latest;
    }
}

