/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.lang.reflect.InvocationTargetException;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public abstract class AsyncCommand
implements Runnable {
    private static final Logger log = Logger.getLogger(AsyncCommand.class);
    private final String commandName;

    public AsyncCommand(String commandName) {
        this.commandName = commandName;
    }

    public final void run() {
        try {
            this.execute();
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            this.handleException(e, this.commandName);
        }
    }

    protected abstract void execute() throws Throwable;

    protected void handleException(Throwable e, String commandName) {
        log.error(e, String.valueOf(commandName) + "\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
    }
}

