/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import jp.sourceforge.mergedoc.pleiades.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.aspect.EclipseFiles;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherEclipseTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherTransformer;
import jp.sourceforge.mergedoc.pleiades.log.Dialogs;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.log.PopupFileLogger;

public class Pleiades {
    private static Logger log;
    public static final String PACKAGE_NAME;
    private static OS os;
    private static PleiadesOption pleiadesOption;
    private static File pleiadesConfigurationPath;
    private static Instrumentation instrumentation;

    static {
        PACKAGE_NAME = Pleiades.class.getPackage().getName();
    }

    public static void premain(String agentArg, Instrumentation inst) throws Throwable {
        long start = System.nanoTime();
        try {
            instrumentation = inst;
            pleiadesOption = new PleiadesOption(agentArg);
            Pleiades.init();
        }
        catch (Throwable e) {
            Dialogs.fatal(e, "Pleiades \u521d\u671f\u5316\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e.getMessage(), new Object[0]);
            throw e;
        }
        try {
            if (Pleiades.getOS() != OS.WINDOWS && Pleiades.getOS() == OS.MAC) {
                Pleiades.pleiadesOption.isNoMnemonic = true;
            }
            Analyses.end(Pleiades.class, "premain", start);
            Pleiades.startLauncherTransformer(agentArg);
        }
        catch (Throwable e) {
            StringBuilder msg = new StringBuilder();
            msg.append("AOP \u8d77\u52d5\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n");
            if (pleiadesConfigurationPath != null && pleiadesConfigurationPath.exists()) {
                msg.append(pleiadesConfigurationPath);
                msg.append("\n\u4e0a\u8a18\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30fc\u3092\u524a\u9664\u3057\u3066\u3001");
            }
            msg.append("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u306b -clean \u3092\u6307\u5b9a\u3057\u3066\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            log.fatal(e, msg.toString(), new Object[0]);
            System.exit(-1);
        }
    }

    private static void init() throws IOException {
        long start = System.nanoTime();
        EclipseFiles.init("configuration");
        pleiadesConfigurationPath = EclipseFiles.getPleiadesConfigurationPath();
        File logFile = new File(pleiadesConfigurationPath, "pleiades.log");
        Logger.init(PopupFileLogger.class, Pleiades.pleiadesOption.logLevel, logFile);
        log = Logger.getLogger(Pleiades.class);
        log.info("Pleiades \u69cb\u6210\u4fdd\u7ba1\u30d1\u30b9: " + pleiadesConfigurationPath, new Object[0]);
        Analyses.end(Pleiades.class, "init", start);
    }

    private static void startLauncherTransformer(String agentArg) {
        String message = " AOP \u8d77\u52d5\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u3092\u958b\u59cb\u3057\u307e\u3059\u3002Pleiades \u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3:" + agentArg;
        if (System.getProperty("java.class.path").contains("org.eclipse.")) {
            instrumentation.addTransformer(new LauncherEclipseTransformer());
            log.info("Eclipse" + message, new Object[0]);
        } else {
            instrumentation.addTransformer(new LauncherTransformer());
            Pleiades.pleiadesOption.isUnderscoreMnemonic = true;
            log.info("Java \u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3" + message, new Object[0]);
        }
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static PleiadesOption getPleiadesOption() {
        if (pleiadesOption == null) {
            pleiadesOption = new PleiadesOption(null);
        }
        return pleiadesOption;
    }

    public static File getResourceFile(String path) {
        return new File(pleiadesConfigurationPath, path);
    }

    public static OS getOS() {
        if (os != null) {
            return os;
        }
        String osName = System.getProperty("os.name", "").toLowerCase();
        os = osName.contains("mac") ? OS.MAC : (osName.contains("windows") ? OS.WINDOWS : OS.LINUX);
        return os;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        LINUX,
        MAC,
        WINDOWS;

    }
}

